package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that shows only the selection in the graph.
 */
public class ShowSelectionOnly extends AbstractEditorAction {

    public ShowSelectionOnly(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.showSelectionOnly");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            getViewable().getOIModelGraph().showOnlyEntities(getViewable().getOIModelerSelectionModel().getSelectedEntities());
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getShowGraph() && !getViewable().getOIModelerSelectionModel().getSelectedEntities().isEmpty());
    }
}
