package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * Action that shows the graph for screen capture.
 */
public class ShowGraphForScreenCapture extends AbstractEditorAction {

    public ShowGraphForScreenCapture(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.showGraphForScreenCapture");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelGraphPane oimodelGraphPane=getViewable().getOIModelGraphPane();
        oimodelGraphPane.setShowForScreenCapture(!oimodelGraphPane.getShowForScreenCapture());
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(getViewable()!=null && getViewable().getOIModelGraphPane().getShowForScreenCapture());
    }
}
