package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * Action that shows the graph in black-and-white.
 */
public class ShowGraphBlackAndWhite extends AbstractEditorAction {

    public ShowGraphBlackAndWhite(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.showGraphBlackAndWhite");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelGraphPane oimodelGraphPane=getViewable().getOIModelGraphPane();
        oimodelGraphPane.setShowBlackAndWhite(!oimodelGraphPane.getShowBlackAndWhite());
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(getViewable()!=null && getViewable().getOIModelGraphPane().getShowBlackAndWhite());
    }
}
