package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;

/**
 * Action that determines whether the evolution details should be shown.
 */
public class ShowEvolutionDetails extends AbstractEditorAction {

    public ShowEvolutionDetails(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.showEvolutionDetails");
    }
    public void actionPerformed(ActionEvent e) {
        boolean currentValue=m_oimodelerModule.getAppDriver().getConfiguration().getBoolean("oimodeler.showEvolution",true);
        m_oimodelerModule.getAppDriver().getConfiguration().setBoolean("oimodeler.showEvolution",!currentValue);
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(m_oimodelerModule.getAppDriver().getConfiguration().getBoolean("oimodeler.showEvolution",true));
    }
}
