package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that makes this OI-model original.
 */
public class SetOIModelOriginal extends AbstractEditorAction {

    public SetOIModelOriginal(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.setOIModelOriginal");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            DistributedEvolutionStrategy.makeOriginal(getViewable().getOIModel());
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        try {
            setEnabled(commandsAreEnabled() && DistributedEvolutionStrategy.isReplica(getViewable().getOIModel()));
        }
        catch (KAONException error) {
            setEnabled(false);
        }
    }
}
