package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that sets the language of the OI-modeler.
 */
public class SetLanguage extends AbstractEditorAction implements ModalSmartAction {

    public SetLanguage(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.setLanguage");
    }
    public void actionPerformed(ActionEvent e) {
        String languageCode=e.getActionCommand();
        getViewable().setLanguageURI(KAONVocabularyAdaptor.INSTANCE.getLanguageURI(languageCode));
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
    public String[][] getModalOptions() {
        return m_oimodelerModule.getLanguages();
    }
    public boolean isOptionSelected(int optionIndex) {
        String selectedLanguageURI=getViewable().getLanguageURI();
        String languageURI=KAONVocabularyAdaptor.INSTANCE.getLanguageURI(m_oimodelerModule.getLanguages()[optionIndex][0]);
        return languageURI.equals(selectedLanguageURI);
    }
}
