package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.evolutionlog.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.commands.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that updates all replicas included in this OI-model.
 */
public class ResolveReplicationInconsistency extends AbstractEditorAction {

    public ResolveReplicationInconsistency(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.resolveReplicationInconsistency");
    }
    public void actionPerformed(ActionEvent e) {
        final OIModelerViewable oimodelerViewable=getViewable();
        oimodelerViewable.startOIModelProcessing();
        ProgressDlg progressDlg=new ProgressDlg(m_oimodelerModule,"oimodeler.resolveReplicationInconsistency",false);
        progressDlg.executeAction(new ProgressDlg.AsynchronousAction() {
            public void run(final ProgressDlg progressDlg) throws Exception {
                DistributedEvolutionStrategy distributedEvolutionStrategy=new DistributedEvolutionStrategy(oimodelerViewable.getKAONConnection());
                List changeEvents=distributedEvolutionStrategy.updateFromOriginal(getViewable().getOIModel());
                oimodelerViewable.executeCommandEx(new ChangeOIModelCmd(oimodelerViewable.getOIModel(),changeEvents,oimodelerViewable.getDependentEvolutionStrategy(),oimodelerViewable.getKAONConnectionEvolutionLogs(),EvolutionLog.LOG_NORMAL,oimodelerViewable) {
                    public boolean executeAsynchronously() {
                        return false;
                    }
                    protected void commandWillBeExecuted() {
                    }
                    protected void commandExecuted() {
                    }
                });
            }
            public void completion(ProgressDlg progressDlg,boolean success) {
                oimodelerViewable.finishOIModelProcessing();
            }
        });
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
