package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collection;
import java.util.Collections;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;
import de.fzi.wim.oimodeler.lexicon.*;
import de.fzi.wim.oimodeler.inclusion.*;

/**
 * Action that removes selected entities.
 */
public class RemoveSelectedEntities extends AbstractEditorAction {

    public RemoveSelectedEntities(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeSelectedEntities");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            List changes=new LinkedList();
            Iterator selection=getSelection().iterator();
            while (selection.hasNext()) {
                Object object=selection.next();
                if (object instanceof Entity) {
                    Entity entity=(Entity)object;
                    changes.add(new RemoveEntity(entity.getSourceOIModel(),null,entity));
                }
                else if (object instanceof PropertyInstance) {
                    PropertyInstance propertyInstance=(PropertyInstance)object;
                    changes.add(new RemovePropertyInstance(propertyInstance.getSourceOIModel(),null,propertyInstance));
                }
                else if (object instanceof LexiconTable.LexiconSelection) {
                    OIModel oimodel=getViewable().getOIModel();
                    Property referencesProperty=oimodel.getProperty(KAONVocabularyAdaptor.INSTANCE.getReferences());
                    LexiconTable.LexiconSelection selectedObject=(LexiconTable.LexiconSelection)object;
                    PropertyInstance propertyInstance=oimodel.getPropertyInstance(referencesProperty,selectedObject.m_lexicalEntry,selectedObject.m_referencedEntity.getSpanningInstance());
                    changes.add(new RemovePropertyInstance(propertyInstance.getSourceOIModel(),null,propertyInstance));
                }
                else if (object instanceof OIModelInclusionTreeModel.OIModelNode) {
                    OIModelInclusionTreeModel.OIModelNode oimodelNode=(OIModelInclusionTreeModel.OIModelNode)object;
                    if (oimodelNode.getParentOIModel()!=null)
                        oimodelNode.getParentOIModel().applyChanges(Collections.singletonList(new RemoveIncludedOIModel(oimodelNode.getParentOIModel(),null,oimodelNode.getOIModel())));
                }
            }
            if (!changes.isEmpty())
                getViewable().changeOIModel(changes);
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        Collection selection=getSelection();
        boolean isSingular=selection.size()==1;
        setEnabled(commandsAreEnabled() && !selection.isEmpty());
        String pseudoActionID=getActionID();
        if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_CONCEPTS)
            pseudoActionID=isSingular ? "action.oimodeler.removeSelectedConcept" : "action.oimodeler.removeSelectedConcepts";
        else if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_PROPERTIES)
            pseudoActionID=isSingular ? "action.oimodeler.removeSelectedProperty" : "action.oimodeler.removeSelectedProperties";
        else if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_INSTANCES)
            pseudoActionID=isSingular ? "action.oimodeler.removeSelectedInstance" : "action.oimodeler.removeSelectedInstances";
        else if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_PROPERTY_INSTANCES)
            pseudoActionID=isSingular ? "action.oimodeler.removeSelectedPropertyInstance" : "action.oimodeler.removeSelectedPropertyInstances";
        else if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_LEXICAL_REFERENCES)
            pseudoActionID=isSingular ? "action.oimodeler.removeSelectedLeixcalReference" : "action.oimodeler.removeSelectedLeixcalReferences";
        else if (getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_OIMODELS)
            pseudoActionID="action.oimodeler.detachOIModelFromParent";
        updateAs(pseudoActionID);
    }
}
