package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected properties from subproperties of the focused property.
 */
public class RemoveFromSuperProperties extends AbstractSingleObjectAction {

    public RemoveFromSuperProperties(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromSuperProperties");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Property)) {
            Property superProperty=(Property)manipulatedEntity;
            Property subProperty=(Property)focusedEntity;
            return new RemoveSubProperty(subProperty.getSuperSubPropertyOIModel(superProperty),null,superProperty,subProperty);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getSuperProperties();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
