package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected concepts from subconcepts of the focused concept.
 */
public class RemoveFromSuperConcepts extends AbstractSingleObjectAction {

    public RemoveFromSuperConcepts(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromSuperConcepts");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Concept)) {
            Concept superConcept=(Concept)manipulatedEntity;
            Concept subConcept=(Concept)focusedEntity;
            return new RemoveSubConcept(subConcept.getSuperSubConceptOIModel(superConcept),null,superConcept,subConcept);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getSuperConcepts();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
