package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected properties from subproperties of the focused property.
 */
public class RemoveFromSubProperties extends AbstractSingleObjectAction {

    public RemoveFromSubProperties(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromSubProperties");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Property)) {
            Property superProperty=(Property)focusedEntity;
            Property subProperty=(Property)manipulatedEntity;
            return new RemoveSubProperty(subProperty.getSuperSubPropertyOIModel(superProperty),null,superProperty,subProperty);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getSubProperties();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
