package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected concepts from the range of the focused property.
 */
public class RemoveFromPropertyRange extends AbstractSingleObjectAction {

    public RemoveFromPropertyRange(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromPropertyRange");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Concept)) {
            Property property=(Property)focusedEntity;
            Concept concept=(Concept)manipulatedEntity;
            return new RemovePropertyRange(property.getRangeConceptOIModel(concept),null,property,concept);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getRangeConcepts();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
