package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected properties from properties pointing to the focused concept.
 */
public class RemoveFromPropertiesTo extends AbstractSingleObjectAction {

    public RemoveFromPropertiesTo(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromPropertiesTo");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Property)) {
            Property property=(Property)manipulatedEntity;
            Concept concept=(Concept)focusedEntity;
            return new RemovePropertyRange(property.getRangeConceptOIModel(concept),null,property,concept);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getPropertiesToConcept();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
