package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected properties from properties pointing from given concept.
 */
public class RemoveFromPropertiesFrom extends AbstractSingleObjectAction {

    public RemoveFromPropertiesFrom(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromPropertiesFrom");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Property)) {
            Property property=(Property)manipulatedEntity;
            Concept concept=(Concept)focusedEntity;
            return new RemovePropertyDomain(property.getDomainConceptOIModel(concept),null,property,concept);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getPropertiesFromConcept();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
