package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected instances from the instances of the focused concept.
 */
public class RemoveFromConceptInstances extends AbstractSingleObjectAction {

    public RemoveFromConceptInstances(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromConceptInstances");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) throws KAONException {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Instance)) {
            Concept concept=(Concept)focusedEntity;
            Instance instance=(Instance)manipulatedEntity;
            return new RemoveInstanceOf(instance.getConceptInstanceOIModel(concept),null,concept,instance);
        }
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        // this hack prevents me from asking for all instances of Root
        Concept concept=(Concept)focusedEntity;
        if (concept.getURI().equals(KAONVocabularyAdaptor.INSTANCE.getRoot()))
            return null;
        else
            return concept.getInstances();
    }
    protected boolean willAddToSet() {
        return false;
    }
}
