package de.fzi.wim.oimodeler.actions;

import java.util.Collection;
import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Removes selected entities from clipboard.
 */
public class RemoveFromClipboard extends AbstractEditorAction {

    public RemoveFromClipboard(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.removeFromClipboard");
    }
    public void actionPerformed(ActionEvent e) {
        Collection entities=getSelection();
        getViewable().getClipboardPane().removeEntities(entities);
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && !getSelection().isEmpty() && getSelectionType()!=OIModelerSelectionSourceManager.CONTAINS_PROPERTY_INSTANCES);
    }
}
