package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.sidebar.*;
import de.fzi.wim.oimodeler.inspector.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that pins down an inspector to the sidebar.
 */
public class PinInspector extends AbstractEditorAction implements ModalSmartAction {

    public PinInspector(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.pinInspector");
    }
    public void actionPerformed(ActionEvent e) {
        String actionID=e.getActionCommand();
        String[] elementNames=getViewable().getEntityInspector().getAvailableElementNames();
        for (int i=0;i<elementNames.length;i++)
            if (actionID.equals(elementNames[i]))
                try {
                    EntityInfoPage entityInfoPage=getViewable().getEntityInspector().createElement(i);
                    getViewable().getSideBar().addElement(new EntityInfoPageSideBarAdapter(getViewable(),elementNames[i],entityInfoPage),true);
                    getViewable().getSideBar().setSelectedIndex(getViewable().getSideBar().getItemCount()-1);
                    break;
                }
                catch (KAONException error) {
                    getViewable().getModule().getAppDriver().displayErrorNotification(error);
                }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getEntityInspector().isVisible());
    }
    public String[][] getModalOptions() {
        String[] elementNames=getViewable().getEntityInspector().getAvailableElementNames();
        String[][] result=new String[elementNames.length][2];
        for (int i=0;i<elementNames.length;i++) {
            result[i][0]=elementNames[i];
            result[i][1]=getViewable().getModule().getAppDriver().getLocalizationManager().getPhrase(elementNames[i]);
        }
        return result;
    }
    public boolean isOptionSelected(int optionIndex) {
        return false;
    }

    /**
     * The adapter for the sidebar.
     */
    public static class EntityInfoPageSideBarAdapter implements OIModelerSideBar.SideBarElement {
        /** The OI-modeler viewable. */
        protected OIModelerViewable m_oimodelerViewable;
        /** The name of the page. */
        protected String m_pageName;
        /** The entity info page being wrapped. */
        protected EntityInfoPage m_entityInfoPage;

        /**
         * Creates an object of this class.
         *
         * @param oimodelerViewable                 the viewable
         * @param pageName                          the name of the page
         * @param entityInfoPage                    the entity info page
         */
        public EntityInfoPageSideBarAdapter(OIModelerViewable oimodelerViewable,String pageName,EntityInfoPage entityInfoPage) {
            m_oimodelerViewable=oimodelerViewable;
            m_pageName=pageName;
            m_entityInfoPage=entityInfoPage;
        }
        /**
         * Sets the current language URI.
         *
         * @param languageURI                       the language URI
         * @throws KAONException                    thrown if there is a problem
         */
        public void setLanguageURI(String languageURI) throws KAONException {
            m_entityInfoPage.setLanguageURI(languageURI);
        }
        /**
         * Returns the label of the element.
         *
         * @return                                  the name of the element
         */
        public String getLabel() {
            String name;
            try {
                name=m_entityInfoPage.getCurrentEntity().getLabel(m_oimodelerViewable.getLanguageURI());
                if (name==null)
                    name=m_entityInfoPage.getCurrentEntity().getURI();
            }
            catch (KAONException ignored) {
                name="<unkown entity>";
            }
            return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().format(m_pageName+".sidebar.title",new String[] { name });
        }
        /**
         * Returns the description of the element.
         *
         * @return                                  the description of the element
         */
        public String getDescription() {
            return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase(m_pageName+".sidebar.description");
        }
        /**
         * Returns the icon of the element.
         *
         * @return                                  the icon of the element
         */
        public Icon getIcon() {
            Entity entity=m_entityInfoPage.getCurrentEntity();
            if (entity instanceof Concept)
                return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.concept");
            else if (entity instanceof Property)
                return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.property");
            else if (entity instanceof Instance)
                return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.instance");
            else
                return null;
        }
        /**
         * Returns the component.
         *
         * @return                                  the component
         */
        public JComponent getComponent() {
            return (JComponent)m_entityInfoPage;
        }
        /**
         * Called when the element is evicted from the sidebar.
         */
        public void removedFromSideBar() {
            m_entityInfoPage.dispose();
        }
    }
}
