package de.fzi.wim.oimodeler.actions;

import java.util.Set;
import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.inference.*;
import de.fzi.wim.oimodeler.ui.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Action that pins down an inference pane to the sidebar.
 */
public class PinInference extends AbstractEditorAction {

    public PinInference(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.pinInference");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelerViewable oimodelerViewable=getViewable();
        if (oimodelerViewable!=null) {
            Set entities=oimodelerViewable.getOIModelerSelectionModel().getSelectedEntities();
            if (entities.size()==1) {
                Entity entity=(Entity)entities.iterator().next();
                InferencePane inferencePane=new InferencePane(oimodelerViewable);
                try {
                    inferencePane.showEntity(entity);
                    inferencePane.setLanguageURI(oimodelerViewable.getLanguageURI());
                    oimodelerViewable.getSideBar().addElement(inferencePane.new SideBarAdapter(),true);
                    oimodelerViewable.getSideBar().setSelectedIndex(oimodelerViewable.getSideBar().getItemCount()-1);
                }
                catch (KAONException error) {
                    inferencePane.dispose();
                    oimodelerViewable.errorLoadingEntity(entity,error);
                }
            }
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getShowGraph() && !getViewable().getOIModelerSelectionModel().getSelectedEntities().isEmpty());
    }
}
