package de.fzi.wim.oimodeler.actions;

import java.util.Map;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that opens an OI-model.
 */
public class OpenOIModel extends AbstractEditorAction {

    public OpenOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.openOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_oimodelerModule,OpenOIModelDlg.OPEN_MODUS,"oimodeler.openOIModel",null);
        openOIModelDlg.setVisible(true);
        String oimodelPhysicalURI=openOIModelDlg.getOIModelPhysicalURI();
        if (openOIModelDlg.isConfirmed() && oimodelPhysicalURI.length()!=0) {
            Map connectionParameters=openOIModelDlg.getConnectionParameters();
            try {
                m_oimodelerModule.getAppDriver().startWaitState();
                try {
                    KAONConnection kaonConnection=KAONManager.getKAONConnection(connectionParameters);
                    try {
                        OIModel oimodel=kaonConnection.openOIModelPhysical(oimodelPhysicalURI);
                        m_oimodelerModule.getAppDriver().newViewableAncor(new OIModelerViewable(m_oimodelerModule,kaonConnection,oimodel));
                    }
                    catch (KAONException error) {
                        kaonConnection.close();
                        throw error;
                    }
                }
                finally {
                    m_oimodelerModule.getAppDriver().endWaitState();
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
        }
    }
}
