package de.fzi.wim.oimodeler.actions;

import java.util.Collections;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Opens an OI-model and makes it included into currently selected OI-model.
 */
public class OpenAndIncludeOIModel extends AbstractEditorAction {

    public OpenAndIncludeOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.openAndIncludeOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelParametersDlg oimodelParametersDlg=new OIModelParametersDlg(m_oimodelerModule, getViewable().getKAONConnection(),"oimodeler.openOIModelForInclusion");
        oimodelParametersDlg.setVisible(true);
        if (oimodelParametersDlg.isConfirmed())
            try {
                KAONConnection kaonConnection=getViewable().getKAONConnection();
                OIModel includedOIModel=null;
                String logicalURI=oimodelParametersDlg.getOIModelLogicalURI();
                if (logicalURI.length()!=0)
                    includedOIModel=kaonConnection.openOIModelLogical(logicalURI);
                else {
                    String physicalURI=oimodelParametersDlg.getOIModelPhysicalURI();
                    if (physicalURI.length()!=0)
                        includedOIModel=kaonConnection.openOIModelPhysical(physicalURI);
                }
                if (includedOIModel!=null) {
                    OIModel includingOIModel=getViewable().getActiveOIModel();
                    includingOIModel.applyChanges(Collections.singletonList(new AddIncludedOIModel(includingOIModel,null,includedOIModel)));
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getActiveOIModel()!=null);
    }
}
