package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that creates a new property.
 */
public class NewProperty extends AbstractEditorAction {

    public NewProperty(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.newProperty");
    }
    public void actionPerformed(ActionEvent e) {
        NewEntityDlg newEntityDlg=new NewEntityDlg(m_oimodelerModule,NewEntityDlg.NEW_PROPERTY_TYPE);
        newEntityDlg.setVisible(true);
        if (newEntityDlg.isConfirmed() && newEntityDlg.getEntityName().length()!=0)
            try {
                String newPropertyName=newEntityDlg.getEntityName();
                OIModel oimodel=getViewable().getActiveOIModel();
                String propertyURI="";
                if (newEntityDlg.shouldCreateUriFromLabel())
                    propertyURI=oimodel.getURI(newPropertyName);
                else
                    propertyURI=oimodel.createNewURI();
                Property newProperty=oimodel.getProperty(propertyURI);
                if (newProperty.isInOIModel()) {
                    String message=m_oimodelerModule.getAppDriver().getLocalizationManager().format("oimodeler.propertyAlreadyExists",new Object[] { newPropertyName });
                    m_oimodelerModule.getAppDriver().displayNotification(message);
                }
                else {
                    List changes=new LinkedList();
                    changes.add(new AddEntity(oimodel,null,newProperty));
                    Iterator selection=getSelection().iterator();
                    while (selection.hasNext()) {
                        Object object=selection.next();
                        if (object instanceof Concept) {
                            Concept domain=(Concept)object;
                            changes.add(new AddPropertyDomain(oimodel,null,newProperty,domain));
                        }
                        else if (object instanceof Property) {
                            Property property=(Property)object;
                            changes.add(new AddSubProperty(oimodel,null,property,newProperty));
                        }
                    }
                    if (newEntityDlg.shouldAddLabel()) {
                        LexicalEntry label=oimodel.getLexicalEntry(oimodel.createNewURI());
                        LexiconUtil.createLexicalEntry(label,KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),newPropertyName,getViewable().getLanguageURI(),newProperty,changes);
                    }
                    getViewable().changeOIModel(changes);
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
