package de.fzi.wim.oimodeler.actions;

import java.util.Map;
import java.util.Collections;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that opens a new OI-model.
 */
public class NewOIModel extends AbstractEditorAction {

    public NewOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.newOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_oimodelerModule,OpenOIModelDlg.CREATE_MODUS,"oimodeler.newOIModel",null);
        openOIModelDlg.setVisible(true);
        String oimodelPhysicalURI=openOIModelDlg.getOIModelPhysicalURI();
        if (openOIModelDlg.isConfirmed() && oimodelPhysicalURI.length()!=0) {
            String oimodelLogicalURI=openOIModelDlg.getOIModelLogicalURI();
            if (oimodelLogicalURI.length()==0)
                oimodelLogicalURI=oimodelPhysicalURI;
            Map connectionParameters=openOIModelDlg.getConnectionParameters();
            try {
                m_oimodelerModule.getAppDriver().startWaitState();
                try {
                    KAONConnection connection=KAONManager.getKAONConnection(connectionParameters);
                    try {
                        OIModel oimodel=connection.createOIModel(oimodelPhysicalURI,oimodelLogicalURI);
                        OIModel lexicalOIModel=connection.openOIModelLogical(KAONConnection.LEXICAL_OIMODEL_URI);
                        oimodel.applyChanges(Collections.singletonList(new AddIncludedOIModel(oimodel,null,lexicalOIModel)));
                        m_oimodelerModule.getAppDriver().newViewableAncor(new OIModelerViewable(m_oimodelerModule,connection,oimodel));
                    }
                    catch (KAONException error) {
                        connection.close();
                        throw error;
                    }
                }
                finally {
                    m_oimodelerModule.getAppDriver().endWaitState();
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
        }
    }
}
