package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Action that creates a new instance.
 */
public class NewInstance extends AbstractEditorAction {

    public NewInstance(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.newInstance");
    }
    public void actionPerformed(ActionEvent e) {
        NewEntityDlg newEntityDlg=new NewEntityDlg(m_oimodelerModule,NewEntityDlg.NEW_INSTANCE_TYPE);
        newEntityDlg.setVisible(true);
        if (newEntityDlg.isConfirmed() && newEntityDlg.getEntityName().length()!=0)
            try {
                String newInstanceName=newEntityDlg.getEntityName();
                OIModel oimodel=getViewable().getActiveOIModel();
                String instanceURI="";
                if (newEntityDlg.shouldCreateUriFromLabel())
                    instanceURI=oimodel.getURI(newInstanceName);
                else
                    instanceURI=oimodel.createNewURI();
                Instance newInstance=oimodel.getInstance(instanceURI);
                if (newInstance.isInOIModel()) {
                    String message=m_oimodelerModule.getAppDriver().getLocalizationManager().format("oimodeler.instanceAlreadyExists",new Object[] { newInstanceName });
                    m_oimodelerModule.getAppDriver().displayNotification(message);
                }
                else {
                    List changes=new LinkedList();
                    changes.add(new AddEntity(oimodel,null,newInstance));
                    Iterator selection=getSelection().iterator();
                    while (selection.hasNext()) {
                        Object object=selection.next();
                        if (object instanceof Concept) {
                            Concept concept=(Concept)object;
                            changes.add(new AddInstanceOf(oimodel,null,concept,newInstance));
                        }
                    }
                    if (newEntityDlg.shouldAddLabel()) {
                        LexicalEntry label=oimodel.getLexicalEntry(oimodel.createNewURI());
                        LexiconUtil.createLexicalEntry(label,KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),newInstanceName,getViewable().getLanguageURI(),newInstance,changes);
                    }
                    getViewable().changeOIModel(changes);
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getSelectionType()==OIModelerSelectionModel.CONTAINS_CONCEPTS);
    }
}
