package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that creates a new concept.
 */
public class NewConcept extends AbstractEditorAction {

    public NewConcept(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.newConcept");
    }
    public void actionPerformed(ActionEvent e) {
        NewEntityDlg newEntityDlg=new NewEntityDlg(m_oimodelerModule,NewEntityDlg.NEW_CONCEPT_TYPE);
        newEntityDlg.setVisible(true);
        if (newEntityDlg.isConfirmed() && newEntityDlg.getEntityName().length()!=0)
            try {
                String newConceptName=newEntityDlg.getEntityName();
                OIModel oimodel=getViewable().getActiveOIModel();
                String conceptURI="";
                if (newEntityDlg.shouldCreateUriFromLabel())
                    conceptURI=oimodel.getURI(newConceptName);
                else
                    conceptURI=oimodel.createNewURI();
                Concept newConcept=oimodel.getConcept(conceptURI);
                if (newConcept.isInOIModel()) {
                    String message=m_oimodelerModule.getAppDriver().getLocalizationManager().format("oimodeler.conceptAlreadyExists",new Object[] { newConceptName });
                    m_oimodelerModule.getAppDriver().displayNotification(message);
                }
                else {
                    boolean hasAtLeastOneParent=false;
                    List changes=new LinkedList();
                    changes.add(new AddEntity(oimodel,null,newConcept));
                    Iterator selection=getSelection().iterator();
                    while (selection.hasNext()) {
                        Object object=selection.next();
                        if (object instanceof Concept) {
                            Concept parent=(Concept)object;
                            changes.add(new AddSubConcept(oimodel,null,parent,newConcept));
                            hasAtLeastOneParent=true;
                        }
                        else if (object instanceof Property) {
                            Property property=(Property)object;
                            changes.add(new AddPropertyDomain(oimodel,null,property,newConcept));
                        }
                    }
                    if (!hasAtLeastOneParent)
                        changes.add(new AddSubConcept(oimodel,null,oimodel.getRootConcept(),newConcept));
                    if (newEntityDlg.shouldAddLabel()) {
                        LexicalEntry label=oimodel.getLexicalEntry(oimodel.createNewURI());
                        LexiconUtil.createLexicalEntry(label,KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),newConceptName,getViewable().getLanguageURI(),newConcept,changes);
                    }
                    getViewable().changeOIModel(changes);
                }
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
