package de.fzi.wim.oimodeler.actions;

import java.util.List;
import java.util.LinkedList;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Makes selected property inverse of the focused property.
 */
public class MakeInverseProperties extends AbstractEditorAction {

    public MakeInverseProperties(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.makeInverseProperties");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            Property focusedProperty=(Property)getFocusedEntity();
            Property property=(Property)getSelection().iterator().next();
            List events=new LinkedList();
            if (focusedProperty.getInverseProperty()!=null)
                events.add(new SetNoInverseProperties(focusedProperty.getInversePropertyOIModel(),null,focusedProperty,focusedProperty.getInverseProperty()));
            events.add(new SetInverseProperties(getViewable().getActiveOIModel(),null,focusedProperty,property));
            getViewable().changeOIModel(events);
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        Entity focusedEntity=getFocusedEntity();
        setEnabled(commandsAreEnabled() && (focusedEntity instanceof Property) && getSelection().size()==1 && getSelectionType()==OIModelerSelectionSourceManager.CONTAINS_PROPERTIES);
    }
}
