package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.guibase.graphview.controller.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * Action that activates the incremental search in the graph.
 */
public class IncrementalSearchGraph extends AbstractEditorAction {

    public IncrementalSearchGraph(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.incrementalSearchGraph");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelGraphPane oimodelGraphPane=getViewable().getOIModelGraphPane();
        oimodelGraphPane.requestFocus();
        IncrementalSearchManipulator incrementalSearchManipulator=(IncrementalSearchManipulator)oimodelGraphPane.getManipulator(IncrementalSearchManipulator.NAME);
        if (incrementalSearchManipulator!=null) {
            incrementalSearchManipulator.startSearch();
            incrementalSearchManipulator.setSearchTerm("");
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getShowGraph());
    }
}
