package de.fzi.wim.oimodeler.actions;

import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.File;
import java.io.IOException;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.apionrdf.*;
import edu.unika.aifb.kaon.apionrdf.importer.*;

import de.fzi.wim.guibase.util.*;
import de.fzi.wim.guibase.configuration.*;
import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that imports a file.
 */
public class Import extends AbstractEditorAction {
    protected static final int PROTEGE_FILTER=1;
    protected static final int RDFS_FILTER=2;

    public Import(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.import");
    }
    public void actionPerformed(ActionEvent e) {
        JFileChooserEx fileChooser=new JFileChooserEx();
        fileChooser.setAcceptAllFileFilterUsed(false);
        LocalizationManager localizationManager=m_oimodelerModule.getAppDriver().getLocalizationManager();
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(PROTEGE_FILTER,localizationManager,"oimodeler.protegeFiles",new String[] { "rdf","rdfs" }));
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(RDFS_FILTER,localizationManager,"oimodeler.rdfsFiles",new String[] { "rdf","rdfs" }));
        Configuration configuration=m_oimodelerModule.getAppDriver().getConfiguration().getSubConfiguration("import");
        String currentDirectory=configuration.getString("currentDirectory");
        if (currentDirectory!=null)
            fileChooser.setCurrentDirectory(new File(currentDirectory));
        if (fileChooser.showOpenDialog(m_oimodelerModule.getAppDriver().getMainFrameWindow())==JFileChooserEx.APPROVE_OPTION) {
            configuration.setString("currentDirectory",fileChooser.getCurrentDirectory().getAbsolutePath());
            File oimodelFile=fileChooser.getSelectedFileEx();
            ModelConsumer modelConsumer=null;
            int filterID=((ExtensionFileFilter)fileChooser.getFileFilter()).getFilterID();
            if (filterID==PROTEGE_FILTER || filterID==RDFS_FILTER) {
                String importAsLabelMessage=localizationManager.getPhrase("oimodeler.importRDFSCommandAsLabel");
                String title=localizationManager.getPhrase("oimodeler.questionTitle");
                boolean importAsLabel=JOptionPane.showConfirmDialog(null,importAsLabelMessage,title,JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE)==JOptionPane.YES_OPTION;
                if (filterID==PROTEGE_FILTER)
                    modelConsumer=new ProtegeImporter(importAsLabel);
                else
                    modelConsumer=new RDFSImporter(importAsLabel);
            }
            KAONConnectionImpl kaonConnection=null;
            InputStream inputStream=null;
            try {
                inputStream=new BufferedInputStream(new FileInputStream(oimodelFile));
                kaonConnection=new KAONConnectionImpl();
                OIModel oimodel=kaonConnection.openOIModelPhysical(oimodelFile.toURI().toString(),inputStream,modelConsumer);
                m_oimodelerModule.getAppDriver().newViewableAncor(new OIModelerViewable(m_oimodelerModule,kaonConnection,oimodel));
                kaonConnection=null;    // so that the finalizer doesn't close the connection
            }
            catch (IOException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
            finally {
                if (inputStream!=null)
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignored) {
                    }
                if (kaonConnection!=null)
                    kaonConnection.close();
            }
        }
    }
}
