package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that hides the selection in the graph.
 */
public class HideSelection extends AbstractEditorAction {

    public HideSelection(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.hideSelection");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            getViewable().getOIModelGraph().hideEntities(getViewable().getOIModelerSelectionModel().getSelectedEntities());
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getShowGraph() && !getViewable().getOIModelerSelectionModel().getSelectedEntities().isEmpty());
    }
}
