package de.fzi.wim.oimodeler.actions;

import java.util.Collection;
import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;

/**
 * Action that inspects the current selection.
 */
public class FocusSelection extends AbstractEditorAction {

    public FocusSelection(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.focusSelection");
    }
    public void actionPerformed(ActionEvent e) {
        Collection selection=getSelection();
        getViewable().getOIModelerSelectionModel().setSelectedEntities(selection);
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getSelection().size()==1);
    }
}
