package de.fzi.wim.oimodeler.actions;

import java.io.OutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.File;
import java.io.IOException;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.apionrdf.exporter.*;

import de.fzi.wim.guibase.util.*;
import de.fzi.wim.guibase.configuration.*;
import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that exports a file.
 */
public class Export extends AbstractEditorAction {

    protected static final int KAON_FILTER = 1;

    protected static final int RDFS_FILTER = 2;

    protected static final int OWLXML_FILTER = 3;

    protected static final int OWLRDF_FILTER = 4;

    public Export(OIModelerModule oimodelerModule) {
        super(oimodelerModule, "action.oimodeler.export");
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooserEx fileChooser = new JFileChooserEx();
        fileChooser.setAcceptAllFileFilterUsed(false);
        LocalizationManager localizationManager = m_oimodelerModule.getAppDriver().getLocalizationManager();
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(KAON_FILTER, localizationManager, "oimodeler.allOIModelerFiles", new String[] { "kaon"}));
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(RDFS_FILTER, localizationManager, "oimodeler.rdfsFiles", new String[] { "rdfs", "rdf"}));
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(OWLXML_FILTER, localizationManager, "oimodeler.allOWLXMLFiles", new String[] { "xml", "xowl"}));
        fileChooser.addChoosableFileFilter(new ExtensionFileFilter(OWLRDF_FILTER, localizationManager, "oimodeler.allOWLRDFFiles", new String[] { "owl"}));
        Configuration configuration = m_oimodelerModule.getAppDriver().getConfiguration().getSubConfiguration("export");
        String currentDirectory = configuration.getString("currentDirectory");
        if (currentDirectory != null) fileChooser.setCurrentDirectory(new File(currentDirectory));
        if (fileChooser.showSaveDialog(m_oimodelerModule.getAppDriver().getMainFrameWindow()) == JFileChooserEx.APPROVE_OPTION) {
            configuration.setString("currentDirectory", fileChooser.getCurrentDirectory().getAbsolutePath());
            File oimodelFile = fileChooser.getSelectedFileEx();
            int filterID = ((ExtensionFileFilter) fileChooser.getFileFilter()).getFilterID();
            AbstractExporter exporter = null;
            switch (filterID) {
            case KAON_FILTER:
                exporter = new KAONExporter();
                break;
            case RDFS_FILTER:
                exporter = new RDFSExporter();
                break;
            case OWLXML_FILTER:
                exporter = new OWLXMLExporter();
                break;
            case OWLRDF_FILTER:
                exporter = new OWLRDFExporter();
                break;
            }
            OutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(oimodelFile));
                exporter.export(getViewable().getOIModel(), oimodelFile.toURI().toString(), outputStream, AbstractExporter.DEFAULT_ENCODING);
            } catch (IOException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            } catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            } catch (InterruptedException ignored) {
            } finally {
                if (outputStream != null) try {
                    outputStream.close();
                } catch (IOException ignored) {
                }
            }
        }
    }

    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}