package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;

import de.fzi.wim.oimodeler.OIModelerModule;
import de.fzi.wim.oimodeler.selection.OIModelerSelectionModel;
import de.fzi.wim.oimodeler.ui.DocumentationEditDlg;
import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Entity;
import edu.unika.aifb.kaon.api.oimodel.LexicalEntry;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.util.LexiconUtil;
import edu.unika.aifb.kaon.api.vocabulary.KAONVocabularyAdaptor;

/**
 * Action that creates a new concept.
 */
public class EditDocumentation extends AbstractEditorAction {

	public EditDocumentation(OIModelerModule oimodelerModule) {
		super(oimodelerModule, "action.oimodeler.editDocumentation");
	}
	public void actionPerformed(ActionEvent e) {
		try {
			// We know that there is exactly one entity, so no check is needed
			Entity entity = (Entity) getSelection().iterator().next();
			LexicalEntry doc =
				entity.getLexicalEntry(
					KAONVocabularyAdaptor.INSTANCE.getDocumentation(),
					getViewable().getLanguageURI());
			String docString = "";
			if (doc != null) {
				docString = doc.getValue();
			}
			DocumentationEditDlg docDlg =
				new DocumentationEditDlg(m_oimodelerModule, docString);
			docDlg.setVisible(true);
			if (docDlg.isConfirmed()) {
				docString = docDlg.getDocumentation();
				List changes = new LinkedList();
				if (doc == null) {
					OIModel om = getViewable().getActiveOIModel();
					doc = om.getLexicalEntry(om.createNewURI());
					LexiconUtil.createLexicalEntry(
						doc,
						KAONVocabularyAdaptor.INSTANCE.getDocumentation(),
						docString,
						getViewable().getLanguageURI(),
						entity,
						changes);
				} else {
					LexiconUtil.setLexicalEntryValue(
						doc,
						docString,
						getViewable().getLanguageURI(),
						changes);
				} //else
				getViewable().changeOIModel(changes);
			} //if confirmed
		} catch (KAONException error) {
			m_oimodelerModule.getAppDriver().displayErrorNotification(error);
		}

	}
	public void updateAction() {
		setEnabled(
			commandsAreEnabled()
				&& getSelection().size() == 1
				&& ((getSelectionType()
					== OIModelerSelectionModel.CONTAINS_INSTANCES)
					|| (getSelectionType()
						== OIModelerSelectionModel.CONTAINS_CONCEPTS)
					|| (getSelectionType()
						== OIModelerSelectionModel.CONTAINS_PROPERTIES)));
	}
}
