package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that duplicates an OI-model wihtin the same KAON connection type.
 */
public class DuplicateOIModel extends AbstractEditorAction {

    public DuplicateOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.duplicateOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            OIModelerViewable sourceOIModelerViewable=getViewable();
            OIModelParametersDlg oimodelParametersDlg=new OIModelParametersDlg(m_oimodelerModule, sourceOIModelerViewable.getKAONConnection(),"oimodeler.duplicateOIModel");
            oimodelParametersDlg.setVisible(true);
            if (oimodelParametersDlg.isConfirmed()) {
                String oimodelPhysicalURI=oimodelParametersDlg.getOIModelPhysicalURI();
                String oimodelLogicalURI=oimodelParametersDlg.getOIModelLogicalURI();
                if (oimodelLogicalURI.length()==0)
                    oimodelLogicalURI=sourceOIModelerViewable.getOIModel().getLogicalURI();
                doCreateDuplicate(oimodelPhysicalURI,oimodelLogicalURI,sourceOIModelerViewable);
            }
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    /**
     * Creates a duplicate within the same type of KAON connection.
     *
     * @param oimodelPhysicalURI            the physical URI of the new model
     * @param oimodelLogicalURI             the logical URI of the new model
     * @param sourceOIModelerViewable       the viewable of the source OI-model
     */
    protected void doCreateDuplicate(final String oimodelPhysicalURI,final String oimodelLogicalURI,final OIModelerViewable sourceOIModelerViewable) {
        sourceOIModelerViewable.startOIModelProcessing();
        ProgressDlg progressDlg=new ProgressDlg(m_oimodelerModule,"oimodeler.duplicateOIModel",false);
        progressDlg.executeAction(new ProgressDlg.AsynchronousAction() {
            protected KAONConnection m_connection=null;
            protected OIModel m_oimodel=null;
            public void run(final ProgressDlg progressDlg) throws Exception {
                OIModel openOIModel=sourceOIModelerViewable.getOIModel();
                m_connection=KAONManager.getKAONConnection(openOIModel.getKAONConnection().getParameters());
                OIModel sourceOIModel=m_connection.openOIModelPhysical(openOIModel.getPhysicalURI());
                m_oimodel=m_connection.createDuplicate(sourceOIModel,oimodelPhysicalURI,oimodelLogicalURI);
            }
            public void completion(ProgressDlg progressDlg,boolean success) {
                if (success) {
                    sourceOIModelerViewable.finishOIModelProcessing();
                    try {
                        m_oimodelerModule.getAppDriver().newViewableAncor(new OIModelerViewable(m_oimodelerModule,m_connection,m_oimodel));
                    }
                    catch (KAONException error) {
                        m_oimodelerModule.getAppDriver().displayErrorNotification(error);
                    }
                }
                else {
                    try {
                        m_connection.close();
                    }
                    catch (KAONException ignored) {
                    }
                    sourceOIModelerViewable.finishOIModelProcessing();
                }
            }
        });
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
