package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.evolutionlog.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that deletes the OI-model evolution Log.
 */
public class DeleteOIModelEvolutionLog extends AbstractEditorAction {

    public DeleteOIModelEvolutionLog(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.deleteOIModelEvolutionLog");
    }
    public void actionPerformed(ActionEvent e) {
        final OIModelerViewable oimodelerViewable=getViewable();
        String message=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase("oimodeler.reallyDeleteEvolutionLog");
        String title=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase("OIModelerModule.title");
        int result=JOptionPane.showConfirmDialog(m_oimodelerModule.getAppDriver().getMainFrameWindow(),message,title,JOptionPane.YES_NO_CANCEL_OPTION);
        if (result==JOptionPane.YES_OPTION) {
            oimodelerViewable.startOIModelProcessing();
            ProgressDlg progressDlg=new ProgressDlg(m_oimodelerModule,"oimodeler.deletingEvolutionLog",false);
            progressDlg.executeAction(new ProgressDlg.AsynchronousAction() {
                public void run(final ProgressDlg progressDlg) throws Exception {
                    EvolutionLog evolutionLog=oimodelerViewable.getKAONConnectionEvolutionLogs().getEvolutionLog(oimodelerViewable.getOIModel());
                    evolutionLog.delete();
                }
                public void completion(ProgressDlg progressDlg,boolean success) {
                    oimodelerViewable.finishOIModelProcessing();
                }
            });
        }
    }
    public void updateAction() {
        try {
            if (commandsAreEnabled()) {
                OIModelerViewable oimodelerViewable=getViewable();
                EvolutionLog evolutionLog=oimodelerViewable.getKAONConnectionEvolutionLogs().getEvolutionLog(oimodelerViewable.getOIModel());
                setEnabled(evolutionLog.isOwnedByDomainOIModel() && evolutionLog.isPersistent());
            }
            else
                setEnabled(false);
        }
        catch (KAONException e) {
            setEnabled(false);
        }
    }
}
