package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.evolutionlog.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that deletes an OI-model.
 */
public class DeleteOIModel extends AbstractEditorAction {

    public DeleteOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.deleteOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        final OIModelerViewable oimodelerViewable=getViewable();
        try {
            String confirmMessage=m_oimodelerModule.getAppDriver().getLocalizationManager().format("oimodeler.reallyDeleteOIModel",new Object[] { oimodelerViewable.getOIModel().getLogicalURI() });
            String confirmTitle=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase("oimodeler.questionTitle");
            if (JOptionPane.showConfirmDialog(null,confirmMessage,confirmTitle,JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE)==JOptionPane.YES_OPTION) {
                oimodelerViewable.startOIModelProcessing();
                ProgressDlg progressDlg=new ProgressDlg(m_oimodelerModule,"oimodeler.deletingOIModel",false);
                progressDlg.executeAction(new ProgressDlg.AsynchronousAction() {
                    public void run(final ProgressDlg progressDlg) throws Exception {
                        EvolutionLog evolutionLog=oimodelerViewable.getKAONConnectionEvolutionLogs().getEvolutionLog(oimodelerViewable.getOIModel());
                        if (evolutionLog.isOwnedByDomainOIModel())
                            evolutionLog.delete();
                        oimodelerViewable.getOIModel().delete();
                    }
                    public void completion(ProgressDlg progressDlg,boolean success) {
                        oimodelerViewable.finishOIModelProcessing();
                    }
                });
            }
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
