package de.fzi.wim.oimodeler.actions;

import java.util.Map;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.evolutionlog.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that creates the OI-model evolution Log.
 */
public class CreateOIModelEvolutionLog extends AbstractEditorAction {

    public CreateOIModelEvolutionLog(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.createOIModelEvolutionLog");
    }
    public void actionPerformed(ActionEvent e) {
        OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_oimodelerModule,OpenOIModelDlg.CREATE_MODUS,"oimodeler.createOIModelEvolutionLog",null);
        openOIModelDlg.setVisible(true);
        String oimodelPhysicalURI=openOIModelDlg.getOIModelPhysicalURI();
        if (openOIModelDlg.isConfirmed() && oimodelPhysicalURI.length()!=0) {
            String oimodelLogicalURI=openOIModelDlg.getOIModelLogicalURI();
            if (oimodelLogicalURI.length()==0)
                oimodelLogicalURI=oimodelPhysicalURI;
            Map connectionParameters=openOIModelDlg.getConnectionParameters();
            OIModelerViewable sourceOIModelerViewable=getViewable();
            try {
                sourceOIModelerViewable.getKAONConnectionEvolutionLogs().createEvolutionLog(sourceOIModelerViewable.getOIModel(),connectionParameters,oimodelPhysicalURI,oimodelLogicalURI);
            }
            catch (KAONException error) {
                m_oimodelerModule.getAppDriver().displayErrorNotification(error);
            }
        }
    }
    public void updateAction() {
        try {
            if (commandsAreEnabled()) {
                OIModelerViewable oimodelerViewable=getViewable();
                EvolutionLog evolutionLog=oimodelerViewable.getKAONConnectionEvolutionLogs().getEvolutionLog(oimodelerViewable.getOIModel());
                setEnabled(evolutionLog.isOwnedByDomainOIModel() && !evolutionLog.isPersistent());
            }
            else
                setEnabled(false);
        }
        catch (KAONException e) {
            setEnabled(false);
        }
    }
}
