package de.fzi.wim.oimodeler.actions;

import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;

import edu.unika.aifb.kaon.engineeringserver.client.*;
import edu.unika.aifb.kaon.engineeringserver.util.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Action that copies an OI-model to a new OI-model.
 */
public class CopyToNewOIModel extends AbstractEditorAction {

    public CopyToNewOIModel(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.copyToNewOIModel");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            OIModel oimodel=getViewable().getOIModel();
            Set oimodelURIs=new HashSet();
            oimodelURIs.add(oimodel.getLogicalURI());
            Iterator iterator=OIModels.getAllIncludedOIModels(oimodel).iterator();
            while (iterator.hasNext()) {
                OIModel includedOIModel=(OIModel)iterator.next();
                oimodelURIs.add(includedOIModel.getLogicalURI());
            }
            OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_oimodelerModule,OpenOIModelDlg.COPY_MODUS,"oimodeler.copyToNewOIModel",oimodelURIs);
            openOIModelDlg.setVisible(true);
            if (openOIModelDlg.isConfirmed())
                doReplication(openOIModelDlg.getConnectionParameters(),openOIModelDlg.getLogicalToPhysicalURIsMap(),getViewable());
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    /**
     * Performs a true replication from a model to a model.
     *
     * @param connectionParameters          the connection parameters
     * @param logicalToPhysicalURIsMap      the map of logical to physical URIs
     * @param sourceOIModelerViewable       the viewable of the source OI-model
     */
    protected void doReplication(final Map connectionParameters,final Map logicalToPhysicalURIsMap,final OIModelerViewable sourceOIModelerViewable) {
        sourceOIModelerViewable.startOIModelProcessing();
        final ProgressDlg progressDlg=new ProgressDlg(m_oimodelerModule,"oimodeler.copyToNewOIModel",true);
        progressDlg.executeAction(new ProgressDlg.AsynchronousAction() {
            protected KAONConnection m_connection=null;
            protected OIModel m_oimodel=null;
            public void run(final ProgressDlg progressDlg) throws Exception {
                m_connection=KAONManager.getKAONConnection(connectionParameters);
                if (m_connection instanceof DirectKAONConnection) {
                    progressDlg.setPrefixID("oimodeler.copyDirectToNewOIModel");
                    DirectOIModelReplicator replicator=new DirectOIModelReplicator(sourceOIModelerViewable.getOIModel(),(DirectKAONConnection)m_connection);
                    replicator.setProgressListener(new OIModelReplicator.ProgressListener() {
                        public void processorProgress(int phase,int done,int steps) {
                            progressDlg.updateProgress(phase,4,done,steps);
                        }
                    });
                    m_oimodel=replicator.doReplication();
                }
                else {
                    OIModelReplicator replicator=new OIModelReplicator(sourceOIModelerViewable.getOIModel(),logicalToPhysicalURIsMap,m_connection);
                    replicator.setProgressListener(new OIModelReplicator.ProgressListener() {
                        public void processorProgress(int phase,int done,int steps) {
                            progressDlg.updateProgress(phase,6,done,steps);
                        }
                    });
                    m_oimodel=replicator.doReplication();
                }
            }
            public void completion(ProgressDlg progressDlg,boolean success) {
                if (success) {
                    sourceOIModelerViewable.finishOIModelProcessing();
                    try {
                        m_oimodelerModule.getAppDriver().newViewableAncor(new OIModelerViewable(m_oimodelerModule,m_connection,m_oimodel));
                    }
                    catch (KAONException error) {
                        m_oimodelerModule.getAppDriver().displayErrorNotification(error);
                    }
                }
                else {
                    try {
                        if (m_connection!=null)
                            m_connection.close();
                    }
                    catch (KAONException ignored) {
                    }
                    sourceOIModelerViewable.finishOIModelProcessing();
                }
            }
        });
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
