package de.fzi.wim.oimodeler.actions;

import java.util.Iterator;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that copies the URIs of selected nodes to the clipboard.
 */
public class CopySelectionURIs extends AbstractEditorAction {
    protected static final String CR=System.getProperty("line.separator");

    public CopySelectionURIs(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.copySelectionURIs");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            StringBuffer selectedURIs=new StringBuffer();
            Iterator iterator=getSelection().iterator();
            boolean first=true;
            while (iterator.hasNext()) {
                Object object=iterator.next();
                if (object instanceof Entity) {
                    Entity entity=(Entity)object;
                    if (first)
                        first=false;
                    else
                        selectedURIs.append(CR);
                    selectedURIs.append(entity.getURI());
                }
            }
            StringSelection stringSelection=new StringSelection(selectedURIs.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection,stringSelection);
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
        catch (IllegalStateException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && !getSelection().isEmpty());
    }
}
