package de.fzi.wim.oimodeler.actions;

import java.util.Collections;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;

/**
 * Removes the inverse property of the focused property.
 */
public class ClearInverseProperty extends AbstractEditorAction {

    public ClearInverseProperty(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.clearInverseProperty");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            Property focusedProperty=(Property)getFocusedEntity();
            getViewable().changeOIModel(Collections.singletonList(new SetNoInverseProperties(focusedProperty.getInversePropertyOIModel(),null,focusedProperty,focusedProperty.getInverseProperty())));
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        try {
            Entity focusedEntity=getFocusedEntity();
            setEnabled(commandsAreEnabled() && (getFocusedEntity() instanceof Property) && ((Property)focusedEntity).getInverseProperty()!=null);
        }
        catch (KAONException error) {
            setEnabled(false);
        }
    }
}
