package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.guibase.sidebar.JSideBar;
import de.fzi.wim.oimodeler.OIModelerModule;
import de.fzi.wim.oimodeler.inference.InferencePane;
import de.fzi.wim.oimodeler.ui.OIModelerViewable;

/**
 * Action that changes the entity in the currently activated inference pane.
 */
public class ChangeInference extends AbstractEditorAction {

    public ChangeInference(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.changeInference");
    }
    public void actionPerformed(ActionEvent e) {
        OIModelerViewable oimodelerViewable=getViewable();
        if (oimodelerViewable!=null) {
            JSideBar sideBar=oimodelerViewable.getSideBar();
            int selectedIndex=sideBar.getSelectedIndex();
            if (selectedIndex>=0) {
                Object selectedComponent=sideBar.getItemComponent(selectedIndex);
                if (selectedComponent instanceof InferencePane) {
                    InferencePane inferencePane=(InferencePane)selectedComponent;
                    inferencePane.reloadEntity();
                }
            }
        }
    }
    public void updateAction() {
        boolean test=false;
        OIModelerViewable oimodelerViewable=getViewable();
        if (oimodelerViewable!=null) {
            JSideBar sideBar=oimodelerViewable.getSideBar();
            int selectedIndex=sideBar.getSelectedIndex();
            if (selectedIndex>=0) {
                Object selectedComponent=sideBar.getItemComponent(selectedIndex);
                if (selectedComponent instanceof InferencePane)
                    test=true;
            }
        }
        setEnabled(commandsAreEnabled() && getViewable().getShowGraph() && test && !getViewable().getOIModelerSelectionModel().getSelectedEntities().isEmpty());
    }
}
