package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected properties to superproperties of the focused property.
 */
public class AddToSuperProperties extends AbstractSingleObjectAction {

    public AddToSuperProperties(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToSuperProperties");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Property))
            return new AddSubProperty(getViewable().getActiveOIModel(),null,(Property)manipulatedEntity,(Property)focusedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getSuperProperties();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
