package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected concepts to superconcepts of the focused concept.
 */
public class AddToSuperConcepts extends AbstractSingleObjectAction {

    public AddToSuperConcepts(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToSuperConcepts");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Concept))
            return new AddSubConcept(getViewable().getActiveOIModel(),null,(Concept)manipulatedEntity,(Concept)focusedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getSuperConcepts();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
