package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected properties to subproperties of the focused property.
 */
public class AddToSubProperties extends AbstractSingleObjectAction {

    public AddToSubProperties(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToSubProperties");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Property))
            return new AddSubProperty(getViewable().getActiveOIModel(),null,(Property)focusedEntity,(Property)manipulatedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getSubProperties();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
