package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected concepts to subconcepts of the focused concept.
 */
public class AddToSubConcepts extends AbstractSingleObjectAction {

    public AddToSubConcepts(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToSubConcepts");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Concept))
            return new AddSubConcept(getViewable().getActiveOIModel(),null,(Concept)focusedEntity,(Concept)manipulatedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getSubConcepts();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
