package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected concepts to the range of the focused property.
 */
public class AddToPropertyRange extends AbstractSingleObjectAction {

    public AddToPropertyRange(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToPropertyRange");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Property) && (manipulatedEntity instanceof Concept))
            return new AddPropertyRange(getViewable().getActiveOIModel(),null,(Property)focusedEntity,(Concept)manipulatedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_PROPERTIES;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Property)focusedEntity).getRangeConcepts();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
