package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected properties to properties pointing to the focused concept.
 */
public class AddToPropertiesTo extends AbstractSingleObjectAction {

    public AddToPropertiesTo(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToPropertiesTo");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Property))
            return new AddPropertyRange(getViewable().getActiveOIModel(),null,(Property)manipulatedEntity,(Concept)focusedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getPropertiesToConcept();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
