package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected properties to properties from given concept.
 */
public class AddToPropertiesFrom extends AbstractSingleObjectAction {

    public AddToPropertiesFrom(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToPropertiesFrom");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Property))
            return new AddPropertyDomain(getViewable().getActiveOIModel(),null,(Property)manipulatedEntity,(Concept)focusedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        return ((Concept)focusedEntity).getPropertiesFromConcept();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
