package de.fzi.wim.oimodeler.actions;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected instances to instances of the focused concept.
 */
public class AddToConceptInstances extends AbstractSingleObjectAction {

    public AddToConceptInstances(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToConceptInstances");
    }
    protected ChangeEvent getChangeEvent(Entity focusedEntity,Entity manipulatedEntity) {
        if ((focusedEntity instanceof Concept) && (manipulatedEntity instanceof Instance))
            return new AddInstanceOf(getViewable().getActiveOIModel(),null,(Concept)focusedEntity,(Instance)manipulatedEntity);
        else
            return null;
    }
    protected int getAlloverFocusedType() {
        return OIModelerSelectionModel.CONTAINS_CONCEPTS;
    }
    protected Set getRelatedSet(Entity focusedEntity) throws KAONException {
        // this hack prevents me from asking for all instances of Root
        Concept concept=(Concept)focusedEntity;
        if (concept.getURI().equals(KAONVocabularyAdaptor.INSTANCE.getRoot()))
            return null;
        else
            return concept.getInstances();
    }
    protected boolean willAddToSet() {
        return true;
    }
}
