package de.fzi.wim.oimodeler.actions;

import java.util.Collection;
import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds selected entities to clipboard.
 */
public class AddToClipboard extends AbstractEditorAction {

    public AddToClipboard(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addToClipboard");
    }
    public void actionPerformed(ActionEvent e) {
        Collection entities=getSelection();
        getViewable().getClipboardPane().addEntities(entities);
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && !getSelection().isEmpty() && getSelectionType()!=OIModelerSelectionSourceManager.CONTAINS_PROPERTY_INSTANCES);
    }
}
