package de.fzi.wim.oimodeler.actions;

import java.util.Iterator;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;
import java.util.Arrays;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.util.*;

import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.selection.*;

/**
 * Adds a relation instance to between two instances.
 */
public class AddRelationInstance extends AbstractEditorAction implements ModalSmartAction {

    public AddRelationInstance(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addRelationInstance");
    }
    public void actionPerformed(ActionEvent e) {
        String propertyURI=e.getActionCommand();
        if (propertyURI==null)
            return;
        try {
            Instance sourceInstance=(Instance)getFocusedEntity();
            Property property=getViewable().getOIModel().getProperty(propertyURI);
            List events=new LinkedList();
            Iterator selection=getSelection().iterator();
            while (selection.hasNext()) {
                Object object=selection.next();
                if (object instanceof Instance)
                    events.add(new AddPropertyInstance(getViewable().getActiveOIModel(),null,property,sourceInstance,(Instance)object));
            }
            getViewable().changeOIModel(events);
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        String[][] modalOptions=getModalOptions();
        setEnabled(modalOptions!=null && modalOptions.length!=0);
    }
    public String[][] getModalOptions() {
        try {
            if (!commandsAreEnabled() || getOIModelerSelectionType()!=OIModelerSelectionModel.CONTAINS_INSTANCES || getOIModelerSelection().size()!=1 || getSelection().isEmpty())
                return null;
            Instance sourceInstance=(Instance)getFocusedEntity();
            Set allowedProperties=PropertyInstanceUtil.getAllowedProperties(sourceInstance,getSelection());
            if (allowedProperties.isEmpty())
                return null;
            String languageURI=getViewable().getLanguageURI();
            String[][] result=new String[allowedProperties.size()][2];
            int index=0;
            Iterator iterator=allowedProperties.iterator();
            while (iterator.hasNext()) {
                Property property=(Property)iterator.next();
                result[index][0]=property.getURI();
                result[index][1]=property.getLabel(languageURI);
                if (result[index][1]==null)
                    result[index][1]=result[index][0];
                index++;
            }
            Arrays.sort(result,BY_LABEL_OPTIONS_COMPARATOR);
            return result;
        }
        catch (KAONException e) {
            return null;
        }
    }
    public boolean isOptionSelected(int optionIndex) {
        return false;
    }
}
