package de.fzi.wim.oimodeler.actions;

import java.util.Iterator;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;
import java.util.HashSet;
import java.util.Collection;
import java.util.Arrays;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.util.*;

import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.*;

/**
 * Adds an attribute to an instances.
 */
public class AddAttributeInstance extends AbstractEditorAction implements ModalSmartAction {

    public AddAttributeInstance(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.addAttributeInstance");
    }
    public void actionPerformed(ActionEvent e) {
        String propertyURI=e.getActionCommand();
        if (propertyURI==null)
            return;
        try {
            Property property=getViewable().getOIModel().getProperty(propertyURI);
            if (property.isAttribute()) {
                String value=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase("oimodeler.newAttributeValue");
                List events=new LinkedList();
                Iterator selection=getSelection().iterator();
                while (selection.hasNext()) {
                    Object object=selection.next();
                    if (object instanceof Instance)
                        events.add(new AddPropertyInstance(getViewable().getActiveOIModel(),null,property,(Instance)object,value));
                }
                getViewable().changeOIModel(events);
            }
        }
        catch (KAONException error) {
            m_oimodelerModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        String[][] modalOptions=getModalOptions();
        setEnabled(modalOptions!=null && modalOptions.length!=0);
    }
    public String[][] getModalOptions() {
        try {
            if (!commandsAreEnabled() || getSelection().isEmpty())
                return null;
            Set allowedProperties=new HashSet();
            Collection selection=getSelection();
            Iterator iterator=selection.iterator();
            while (iterator.hasNext()) {
                Object selectedObject=iterator.next();
                if (!(selectedObject instanceof Instance))
                    return null;
                Instance instance=(Instance)selectedObject;
                Iterator parentConcepts=instance.getParentConcepts().iterator();
                while (parentConcepts.hasNext()) {
                    Concept concept=(Concept)parentConcepts.next();
                    allowedProperties.addAll(concept.getAllPropertiesFromConcept());
                }
            }
            String languageURI=getViewable().getLanguageURI();
            Iterator properties=allowedProperties.iterator();
            while (properties.hasNext()) {
                Property property=(Property)properties.next();
                if (!property.isAttribute())
                    properties.remove();
                else {
                    Set domainConcepts=property.getDomainConcepts();
                    iterator=selection.iterator();
                    while (iterator.hasNext()) {
                        Instance sourceInstance=(Instance)iterator.next();
                        if (!PropertyInstanceUtil.instanceSatisfiesConceptSet(sourceInstance,domainConcepts)) {
                            properties.remove();
                            break;
                        }
                    }
                }
            }
            if (allowedProperties.isEmpty())
                return null;
            String[][] result=new String[allowedProperties.size()][2];
            int index=0;
            iterator=allowedProperties.iterator();
            while (iterator.hasNext()) {
                Property property=(Property)iterator.next();
                result[index][0]=property.getURI();
                result[index][1]=property.getLabel(languageURI);
                if (result[index][1]==null)
                    result[index][1]=result[index][0];
                index++;
            }
            Arrays.sort(result,BY_LABEL_OPTIONS_COMPARATOR);
            return result;
        }
        catch (KAONException e) {
            return null;
        }
    }
    public boolean isOptionSelected(int optionIndex) {
        return false;
    }
}
